'use client';

import Link from 'next/link';
import Image from 'next/image';
import { Heart } from 'lucide-react';

/**
 * Footer component - Light Theme
 */
export default function Footer() {
  const currentYear = new Date().getFullYear();

  return (
    <footer className="border-t border-gray-200 bg-white">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-8 mb-8">
          {/* Brand - Logo unchanged */}
          <div className="md:col-span-2">
            <Link href="/" className="flex items-center mb-4">
              <div className="relative h-10 w-28">
                <Image
                  src="/belive-logo.png"
                  alt="beLIVE"
                  fill
                  className="object-contain"
                />
              </div>
            </Link>
            <p className="text-gray-500 text-sm max-w-md mb-4">
              Discover the most exciting events happening around the world. 
              From tech conferences to cultural festivals, find your next experience.
            </p>
            <p className="text-xs text-gray-400">
              Powered by Parallel AI FindAll API
            </p>
          </div>

          {/* Quick Links */}
          <div>
            <h3 className="font-medium text-gray-900 mb-4">Explore</h3>
            <ul className="space-y-2">
              <li>
                <Link href="/" className="text-sm text-gray-500 hover:text-[#E11D2E] transition-colors">
                  All Events
                </Link>
              </li>
              <li>
                <Link href="/?eventType=conference" className="text-sm text-gray-500 hover:text-[#E11D2E] transition-colors">
                  Conferences
                </Link>
              </li>
              <li>
                <Link href="/?eventType=exhibition" className="text-sm text-gray-500 hover:text-[#E11D2E] transition-colors">
                  Exhibitions
                </Link>
              </li>
              <li>
                <Link href="/?eventType=festival" className="text-sm text-gray-500 hover:text-[#E11D2E] transition-colors">
                  Festivals
                </Link>
              </li>
            </ul>
          </div>

          {/* Countries */}
          <div>
            <h3 className="font-medium text-gray-900 mb-4">Countries</h3>
            <ul className="space-y-2">
              <li>
                <Link href="/?country=UAE" className="text-sm text-gray-500 hover:text-[#E11D2E] transition-colors">
                  UAE
                </Link>
              </li>
              <li>
                <Link href="/?country=Saudi Arabia" className="text-sm text-gray-500 hover:text-[#E11D2E] transition-colors">
                  Saudi Arabia
                </Link>
              </li>
              <li>
                <Link href="/?country=Qatar" className="text-sm text-gray-500 hover:text-[#E11D2E] transition-colors">
                  Qatar
                </Link>
              </li>
              <li>
                <Link href="/?country=Egypt" className="text-sm text-gray-500 hover:text-[#E11D2E] transition-colors">
                  Egypt
                </Link>
              </li>
            </ul>
          </div>
        </div>

        {/* Bottom */}
        <div className="pt-8 border-t border-gray-200 flex flex-col sm:flex-row items-center justify-between gap-4">
          <p className="text-xs text-gray-400">
            © {currentYear} beLIVE. All rights reserved.
          </p>
          <p className="text-xs text-gray-400 flex items-center gap-1">
            Made with <Heart className="w-3 h-3 text-[#E11D2E]" /> for event enthusiasts
          </p>
        </div>
      </div>
    </footer>
  );
}
